/*____________________________________________________________________________
        Copyright (C) 2000 Networks Associates Technology, Inc.
        All rights reserved.

        $Id: pgpX509Priv.h,v 1.19 2001/02/15 21:56:36 ajivsov Exp $
____________________________________________________________________________*/

#ifndef Included_pgpX509Priv_h
#define Included_pgpX509Priv_h

#include "pgpX509Cert_asn.h"
#include "pgpOpaqueStructs.h"

PGP_BEGIN_C_DECLARATIONS

/* Internal functions */

PGPKeyDBObj *	 pgpX509FindNamedSig( PGPKeyDB *keydb, char const *namebuf,
						PGPSize namebuflen);

PGPError		pgpX509BufferToCert (PGPContextRef context, PGPByte *buf,
						PGPSize len, PGPASN_Certificate **cert);

PGPError		pgpX509FreeCert (PGPContextRef context,
						PGPASN_Certificate *cert);

PGPError		pgpX509BufferToXTBSCert (PGPContextRef context,
						PGPByte const *buf, PGPSize len,
						PGPASN_XTBSCertificate **xtbscert);

PGPError		pgpX509FreeXTBSCert (PGPContextRef context,
						PGPASN_XTBSCertificate *xtbscert);

PGPError		pgpX509BufferToCRL (PGPContextRef context, PGPByte *buf,
						PGPSize len, PGPASN_CertificateRevocationList **crl);

PGPError		pgpX509FreeCRL (PGPContextRef context,
						PGPASN_CertificateRevocationList *crl);

PGPError		pgpX509CertToSigBuffer (PGPContextRef context, MemPool *pool,
						PGPASN_Certificate *cert, PGPByte loversion,
						PGPByte **buf, PGPSize *pktlen);

PGPError		pgpX509CertToKeyBuffer (PGPContextRef context, MemPool *pool,
						PGPKeyDBRef refdb, PGPASN_Certificate *cert,
						PGPByte loversion, PGPByte **buf, PGPSize *pktlen);

PGPError		pgpX509CertToUserIDBuffer (PGPContextRef context,MemPool *pool,
						PGPASN_Certificate *cert, PGPByte loversion,
						PGPByte **buf, PGPSize *pktlen);

PGPError		pgpX509CertInfoPartition( PGPByte *buf, PGPSize len,
						PGPByte **serialbuf, PGPSize *seriallen,
						PGPByte **sigalgbuf, PGPSize *sigalglen,
						PGPByte **issuerbuf, PGPSize *issuerlen,
						PGPByte **validitybuf, PGPSize *validitylen,
						PGPByte **subjectbuf, PGPSize *subjectlen,
						PGPByte **publickeyinfobuf, PGPSize *publickeyinfolen);

PGPError		pgpX509SignatureBitString( PGPByte *buf, PGPSize len,
						PGPByte **rawbuf, PGPSize *rawlen );

PGPError		pgpX509CertPartition( PGPByte *buf, PGPSize len,
						PGPByte **certinfobuf, PGPSize *certinfolen,
						PGPByte **sigalgbuf, PGPSize *sigalglen,
						PGPByte **sigbuf, PGPSize *siglen );

PGPError		pgpX509DecodeTime( PGPASN_Time *tm, PGPUInt32 *pgptime );

PGPError		pgpX509CertToIASN( PGPByte *cert, PGPSize len,
						PGPByte *buf, PGPSize *pktlen );

PGPError        pgpX509CertToSerialNumber (const PGPByte *certbuf, PGPSize len, 
                        PGPByte *sn, PGPSize *snLen);

PGPError		pgpX509CertToLongName( PGPByte *cert, PGPSize len,
						PGPBoolean doIssuer, PGPByte *buf, PGPSize *pktlen );

PGPError		pgpX509CertToDName( PGPByte *cert, PGPSize len,
						PGPBoolean doIssuer, PGPByte *buf, PGPSize *pktlen );

PGPError		pgpX509CertToIPDNS( PGPByte *cert, PGPSize len,
						PGPBoolean doIP, PGPByte *buf, PGPSize *pktlen );

PGPError		pgpDecodeX509Cert( PGPByte *buf, PGPSize len,
						PGPContextRef context, PGPKeyDBRef refdb,
						PGPKeyDBRef *kset);

PGPError		pgpDecodeX509CertSet( PGPByte *buf, PGPSize len,
						PGPContextRef context, PGPKeyDBRef refdb,
						PGPKeyDBRef *kset);

PGPError		pgpDecodeX509CRLSet( PGPByte *buf, PGPSize len,
						PGPContextRef context, PGPKeyDBRef refdb,
						PGPKeyDBRef *keydb );

PGPError		pgpDecodePCKS8( PGPByte *buf, PGPSize len,
						PGPContextRef context, PGPKeyDBRef keydb,
						PGPKeyDBRef *keys );

PGPError		pgpEncodePKCS8( PGPSecKey const *seckey, PGPByte **pkcs8buf,
						PGPSize *pkcs8buflen );

PGPError		pgpCreateCertSetFromChain( PGPContextRef context,
						PGPKeyDBObjRef bestsig, PGPByte **buf,
						PGPSize *bufLength);

PGPError		pgpX509VerifySignedObject (PGPContextRef context,
						PGPPubKey const *pubkey, PGPByte *buf, PGPSize len);

PGPError		pgpKeyToX509SPKI(PGPContextRef context, PGPKeyDBObj *key,
						PGPByte *keyBuf, PGPSize *keyLength);

PGPBoolean		pgpX509BufInSequenceList( PGPByte const *buf, PGPSize bufsize,
						PGPByte const *seqlist, PGPSize seqlistsize );

PGPSize			pgpX509BufSizeofSequence( PGPByte const *buf, PGPSize bufsize);

PGPByte *		pgpX509XTBSCertToDistPoint (PGPASN_XTBSCertificate *xtbscert,
						PGPSize *pdpointlen);

PGPError		pgpX509CreateCert_internal (PGPContextRef context,
						PGPKeyDBObjRef signer, PGPKeyDBObjRef target,
						PGPTime creationTime, PGPUInt32 validityDays,
						PGPAttributeValue const *formatData,
						PGPSize formatDataSize, PGPByte const *passphrase,
						PGPSize passphraseLength, PGPBoolean hashedPhrase,
						PGPKeyDBObjRef *sig );


/* Interface functions to TIS CMS layer */

#include "pgpOptionList.h"

    PGPError
    X509InputCertificate (
            PGPContextRef       context,
            PGPByte            *input,      /* Input buffer */
            PGPSize             inputSize,
            PGPKeyDBRef         keydb,     /* Where to find keys */
            PGPInputFormat      format,     /* Import format (CA) */
            PGPOptionListRef    passphrase, /* Passphrase for decrypting */
            PGPKeyDBObjRef     *decryptKey, /* Output decryption key */
            PGPKeyDBObjRef     *signKey,    /* Output signing key */
            PGPBoolean         *isSigned,   /* Output flag for signed msg */
            PGPBoolean         *sigChecked, /* Output that we have sig key */
            PGPBoolean         *sigVerified,/* Output flag for sig OK */
            PGPAttributeValue **extraData,  /* Output extra data */
            PGPUInt32          *extraDataCount,
            PGPByte           **certSet,    /* Cert output buffer */
            PGPSize            *certSetSize,
            PGPByte           **crlReqOut,  /* CRL output buffer */
            PGPSize            *crlReqOutSize
    );

/* Create the payload */
    PGPError
    X509CreateCertificateRequest (
            PGPContextRef       context,
            PGPKeyDBObj        *key,        /* Key to export */
            PGPExportFormat     format,     /* Export format (CA) */
            PGPAttributeValue  *formatData, /* Formatting data */
            PGPUInt32           formatDataCount,
            PGPOptionListRef    passphrase, /* Passphrase if signing */
            PGPByte           **certReq,    /* Output buffer */
            PGPSize            *certReqSize /* Output buffer size */
    );


/* Package it in PKCS-7 form */
    PGPError
    X509PackageCertificateRequest (
            PGPContextRef       context,
            PGPByte            *certReqIn,     /* Input buffer */
            PGPSize             certReqInSize, /* Input buffer size */
            PGPKeyDBObjRef      encryptTo,     /* Key to encrypt to */
            PGPCipherAlgorithm  encryptAlg,    /* Encryption algorithm */
            PGPKeyDBObjRef      signWith,      /* Key to sign with */
            PGPOptionListRef    passphrase,    /* Passphrase if signing */
            PGPOutputFormat     format,        /* Export format (CA) */
            PGPByte           **certReqOut,    /* Cert output buffer */
            PGPSize            *certReqOutSize /* Cert output buffer size */
    );


/* Create a GetCRL message */
PGPError
X509CreateCRLRequest (
    PGPContextRef       context,
    PGPKeyDBObjRef      key,            /* [IN] key for CA we request from */
    PGPByte             *crldistp,      /* [IN] asn.1 crl dist point ext(opt)*/
    PGPSize             crldistpsize,   /* [IN] size of crldistp */
    PGPExportFormat     format,         /* [IN] what type of CA */
    time_t              validity,       /* [IN] CRL for which date */
    PGPByte             **request,      /* [OUT] der encoded GetCRL msg */
    PGPSize             *requestsize    /* [OUT] size of der encoding */
	);


/* Create a distinguished name buffer */
PGPError
X509CreateDistinguishedName (
	PGPContextRef       context,
	char const			*str,		/* LDAP format string */
	PGPByte           **dname,    /* Output buffer */
	PGPSize            *dnamesize /* Output buffer size */
);

/* Create a distinguished name buffer from AttributeValue array */
PGPError
X509CreateDistinguishedNameFromAV (
	PGPContextRef       context,
	PGPAttributeValue const  *formatData,
	PGPUInt32			formatDataCount,
	PGPByte           **dname,    /* Output buffer */
	PGPSize            *dnamesize /* Output buffer size */
);


/* Create a buffer holding extensions specified by a AV array */
PGPError
X509CreateExtensionsFromAV (
	PGPContextRef       context,
	PGPAttributeValue const  *formatData,
	PGPUInt32			formatDataCount,
	PGPByte           **exts,    /* Output buffer */
	PGPSize            *extssize /* Output buffer size */
);


/* PBE algorithms from PKCS#12 */
/* TODO: only kPGPPBEAlgorithm_SHA3DES is currently supported */
typedef enum {
    kPGPPBEAlgorithm_Unknown,
    kPGPPBEAlgorithm_SHA3DES,	/* sha-1 w/ DES-EDE-3 CBC */
    kPGPPBEAlgorithm_SHADESEDE2,
    kPGPPBEAlgorithm_SHARC4_128,
    kPGPPBEAlgorithm_SHARC4_40,
    kPGPPBEAlgorithm_SHARC2_128,/* sha-1 w/ RC2/128 CBC */
    kPGPPBEAlgorithm_SHARC2_40	/* sha-1 w/ RC2/40 CBC */
} PGPPBEAlgorithm;

PGPError
PKCS12InputKey (
    PGPContextRef	context,		/* [IN] pgp context */
    const PGPByte	*der,			/* [IN] pkcs #12 data */
    PGPSize		dersize,			/* [IN] pkcs #12 data size */
    const PGPByte	*pass,			/* [IN] MAC/decrypt password */
    PGPSize		passlen,			/* [IN] password length */
    PGPByte		**privkey,			/* [OUT] ASN.1 PrivateKeyInfo */
    PGPSize		*privkeysize,		/* [OUT] size of PrivateKeyInfo */
    PGPByte		**cert,				/* [OUT] certificate matching the
									   private key stored in the message */
    PGPSize		*certSize);			/* [OUT] certificate size */

PGPError
PKCS12ExportKey (
    PGPContextRef	context,		/* [IN] PGP context */
    const PGPByte	*privKeyInfo,	/* [IN] DER of PKCS-8 PrivateKeyInfo */
    PGPSize		privKeyInfoSize,	/* [IN] size in bytes of privKeyInfo */
    const PGPByte	*password,		/* [IN] password to use for
									   MAC/symmetric encryption */
    PGPSize		passwordSize,		/* [IN] length in bytes of password */
    const PGPByte	*certificatelist,	/* [IN] DER of X.509 cert list */
    PGPSize		certificatelistSize,	/* [IN] size of X.509 cert list */
    const PGPByte	*friendlyName,	/* [IN] Name to put in attributes */
    PGPSize		friendlyLen	,		/* [IN] size in bytes friendlyName */
    int			macIterations,		/* [IN] number of iterations in
									   generation of MAC key */
    int			pbeIterations,		/* [IN] number of iterations in
									   generation of PBE key */
    PGPPBEAlgorithm	pbeAlgorithm,	/* [IN] PBE algorithm to use */
    PGPByte		**pkcs12der,		/* [OUT] PKCS-12 DER */
    PGPSize		*pkcs12derSize);	/* [OUT] size in bytes of PKCS-12 DER */



PGP_END_C_DECLARATIONS

#endif /* pgpX509Priv.h */

/*
 * Local Variables:
 * tab-width: 4
 * End:
 * vi: ts=4 sw=4
 * vim: si
 */
